<?php
/**
 * Template part for Header Top Bar.
 *
 * @package gmaakeup
 */

$gmaakeup_data =get_option('gmaakeup_data'); 
?>  
<header class="header-area">     
      <div id="header-sticky" class="menu-area">
            <div class="container">               
                    <div class="row align-items-center">
                        <div class="col-xl-2 col-lg-2">
                            <div class="logo">
                                 <!-- LOGO IMAGE -->
                                    <!-- For Retina Ready displays take a image with double the amount of pixels that your image will be displayed (e.g 268 x 60 pixels) -->
                                    <?php if(isset ($gmaakeup_data['gmaakeup__opt-logo-standard']['url']) && $gmaakeup_data['gmaakeup__opt-logo-standard']['url'] !== "") { ?>
                                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="navbar-brand logo-black">
                                    <!-- Logo Standard -->
                                    <img src="<?php echo esc_url( $gmaakeup_data['gmaakeup__opt-logo-standard']['url'] ); ?>" alt="<?php echo esc_attr( get_bloginfo('name') ); ?>" title="<?php echo esc_attr( get_bloginfo('description') ); ?>" />
                                     </a>
                                    <?php } else { ?>
                                    <!-- Logo Text Default -->
                                    <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                                    <?php } ?>
                            </div>
                        </div>

                      <?php if(isset ($gmaakeup_data['gmaakeup__opt-right-menu']) && $gmaakeup_data['gmaakeup__opt-right-menu'] !== 1) { ?>
                           <?php if ( $gmaakeup_data['gmaakeup__opt-right-menu'] == 1) { ?>


                                <div class="col-xl-8 col-lg-8">
                                    <div class="main-menu text-center text-xl-right">
                                        <nav id="mobile-menu">
                                            <?php
                                        wp_nav_menu([
                                             'theme_location'  => 'main-menu',
                                              'container_id' => 'cssmenu', 										
                                        ]);
                                      ?>
                                        </nav>
                                    </div>
                                </div>   

                                <div class="col-xl-2 col-lg-2 text-right d-none d-lg-block mt-25 mb-25 text-right text-xl-right">
                                     <?php if ( $gmaakeup_data['gmaakeup__opt-right-menu'] == 1) { ?> 
                                        <?php echo wp_kses_post( $gmaakeup_data['gmaakeup__right-menu'] ); ?>
                                    <?php } ?>
                                </div>
                              <div class="col-12">
                            <div class="mobile-menu"></div>
                        </div> 

                        <?php } else { ?>

                             <div class="col-xl-10 col-lg-10">
                                <div class="main-menu text-right text-xl-right">
                                     <nav id="mobile-menu">
                                        <?php
                                    wp_nav_menu([
                                         'theme_location'  => 'main-menu',
                                            'container_id' => 'cssmenu', 
                                    ]);
                                  ?>
                                    </nav>
                                </div>
                            </div>
                            <div class="col-12">
                            <div class="mobile-menu"></div>
                       </div> 
                        <?php } ?>

                        <?php } else { ?>
                        <!-- Theme option of this menu display -->
                        <div class="col-xl-10 col-lg-10">
                           <div class="main-menu text-right text-xl-right">
                                 <nav id="mobile-menu">
                                    <?php
                                        wp_nav_menu([
                                             'theme_location'  => 'main-menu',
                                            'container_id' => 'cssmenu', 							
                                        ]);
                                      ?>
                                </nav>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mobile-menu"></div>
                       </div> 
                        <?php } ?>
                  </div>
               
             </div>
          </div>
    </header>
<!-- header-end -->