<?php
/*
Plugin Name: Zcube Theme Plugin
Plugin URI: http://zcube.in
Description: This plugin creates a custom post types Portfolio and Shortcode is [advanced-portfolio]
Version: 1.0.1
Author: zcube
Author URI: http://zcube.in

*/
/**
 * Register Team Custom Post Type
 */

 function isik__portfolio() {
  $labels = array(
    'name'               => _x( 'Portfolios', 'post type general name' ),
    'singular_name'      => _x( 'Portfolio', 'post type singular name' ),
    'add_new'            => _x( 'Add New', 'book' ),
    'add_new_item'       => __( 'Add New portfolio' ),
    'edit_item'          => __( 'Edit portfolio' ),
    'new_item'           => __( 'New portfolio' ),
    'all_items'          => __( 'All portfolios' ),
    'view_item'          => __( 'View portfolio' ),
    'search_items'       => __( 'Search portfolios' ),
    'not_found'          => __( 'No portfolios found' ),
    'not_found_in_trash' => __( 'No portfolios found in the Trash' ),
    'menu_name'          => 'Portfolios'
  );
  $args = array(
    'labels'        => $labels,
    'description'   => 'Holds our portfolios and portfolio specific data',
    'public'        => true,
    'menu_position' => 5,
    'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
    'has_archive'   => true,
  );
  register_post_type( 'portfolio', $args );
}
add_action( 'init', 'isik__portfolio' );
 function my_taxonomies_portfolio() {
   $labels = array(
     'name'              => _x( 'portfolio Categories', 'taxonomy general name' ),
     'singular_name'     => _x( 'portfolio Category', 'taxonomy singular name' ),
     'search_items'      => __( 'Search portfolio Categories' ),
     'all_items'         => __( 'All portfolio Categories' ),
     'parent_item'       => __( 'Parent portfolio Category' ),
     'parent_item_colon' => __( 'Parent portfolio Category:' ),
     'edit_item'         => __( 'Edit portfolio Category' ),
     'update_item'       => __( 'Update portfolio Category' ),
     'add_new_item'      => __( 'Add New portfolio Category' ),
     'new_item_name'     => __( 'New portfolio Category' ),
     'menu_name'         => __( 'portfolio Categories' ),
   );
   $args = array(
     'labels' => $labels,
     'hierarchical' => true,
   );
   register_taxonomy( 'portfolio_category', 'portfolio', $args );
 }
 add_action( 'init', 'my_taxonomies_portfolio', 0 );
 
 
 
 
// Register Custom Post Type Team
function create_Team_cpt() {

	$labels = array(
		'name' => _x( 'Teams', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'Team', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'Teams', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'Team', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'Team Archives', 'luxia' ),
		'attributes' => __( 'Team Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent Team:', 'luxia' ),
		'all_items' => __( 'All Teams', 'luxia' ),
		'add_new_item' => __( 'Add New Team', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New Team', 'luxia' ),
		'edit_item' => __( 'Edit Team', 'luxia' ),
		'update_item' => __( 'Update Team', 'luxia' ),
		'view_item' => __( 'View Team', 'luxia' ),
		'view_items' => __( 'View Teams', 'luxia' ),
		'search_items' => __( 'Search Team', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into Team', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Team', 'luxia' ),
		'items_list' => __( 'Teams list', 'luxia' ),
		'items_list_navigation' => __( 'Teams list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter Teams list', 'luxia' ),
	);
	$args = array(
		'label' => __( 'Team', 'luxia' ),
		'description' => __( 'post Teams', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'Team', $args );

}
add_action( 'init', 'create_Team_cpt', 0 );


// Register Custom Post Type Service
function create_service_cpt() {

	$labels = array(
		'name' => _x( 'services', 'Post Type General Name', 'luxia' ),
		'singular_name' => _x( 'Service', 'Post Type Singular Name', 'luxia' ),
		'menu_name' => _x( 'services', 'Admin Menu text', 'luxia' ),
		'name_admin_bar' => _x( 'Service', 'Add New on Toolbar', 'luxia' ),
		'archives' => __( 'Service Archives', 'luxia' ),
		'attributes' => __( 'Service Attributes', 'luxia' ),
		'parent_item_colon' => __( 'Parent Service:', 'luxia' ),
		'all_items' => __( 'All services', 'luxia' ),
		'add_new_item' => __( 'Add New Service', 'luxia' ),
		'add_new' => __( 'Add New', 'luxia' ),
		'new_item' => __( 'New Service', 'luxia' ),
		'edit_item' => __( 'Edit Service', 'luxia' ),
		'update_item' => __( 'Update Service', 'luxia' ),
		'view_item' => __( 'View Service', 'luxia' ),
		'view_items' => __( 'View services', 'luxia' ),
		'search_items' => __( 'Search Service', 'luxia' ),
		'not_found' => __( 'Not found', 'luxia' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxia' ),
		'featured_image' => __( 'Featured Image', 'luxia' ),
		'set_featured_image' => __( 'Set featured image', 'luxia' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxia' ),
		'use_featured_image' => __( 'Use as featured image', 'luxia' ),
		'insert_into_item' => __( 'Insert into Service', 'luxia' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Service', 'luxia' ),
		'items_list' => __( 'services list', 'luxia' ),
		'items_list_navigation' => __( 'services list navigation', 'luxia' ),
		'filter_items_list' => __( 'Filter services list', 'luxia' ),
	);
	$args = array(
		'label' => __( 'Service', 'luxia' ),
		'description' => __( 'post services', 'luxia' ),
		'labels' => $labels,
		'menu_icon' => 'dashicons-admin-generic',
		'supports' => array('title', 'editor', 'excerpt', 'thumbnail', 'page-attributes', 'custom-fields'),
		'taxonomies' => array('category'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => false,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'service', $args );

}
add_action( 'init', 'create_service_cpt', 0 );


